#ifndef INC_STATE_H
#define INC_STATE_H

#include <SDL/SDL.h>
#include "coords.h"
#include "gfx.h"
#include "geom.h"

#include <vector>

#define MAX(x,y) ((x) > (y) ? (x) : (y))
#define MIN(x,y) ((x) < (y) ? (x) : (y))
#define BOUNDED(x,min,max) (MAX(MIN((x),(max)),(min)))

class GameState
{
    private:
	int hi,hj;
	int **adjMatrix;
	int adjfrom;

	float zoomRad, targetZoomRad;
	float angle;

	void applyMatrix();
	void stochastify();
	void calcGraphMatrix();
	Uint32 colourOfState(int i);
	bool inputMatrixEntry(SDL_Surface* surface, int i, int j);
	void drawMatrix(SDL_Surface* surface);

    public:
	void update(SDL_Surface* surface, int time);
	void draw(SDL_Surface* surface);
	void handleGameInput(int time);
	void toggleDamping() { dampen = !dampen; if (graph) calcGraphMatrix(); };

	int N;
	float **matrix;
	float *state;
	bool stochastic;
	bool graph;
	bool dampen;
	bool arrows;
	bool linear;
	float period;
	float t;

	GameState(int N, bool stochastic=false, bool graph=false, bool dampen=false, bool arrows=true, bool linear=false) :
	    hi(-1), hj(-1), adjfrom(-1),
	    zoomRad(ARENA_RAD), targetZoomRad(ARENA_RAD), angle(0),
	    N(N), stochastic(stochastic), graph(graph), dampen(dampen),
	    arrows(arrows), linear(linear), period(300), t(0) {
	    //float testMatrix[3][3] = { {0.1,0.3,0.6},{0.2,0.4,0.1},{0.7,0.3,0.3} };
	    //float testState[3] = {0.5,0.3,0.2};
	    const float alpha = 1.1;
	    const float beta = 0.2;
	    //float testMatrix[3][3] = { {alpha,-beta,0.0},{0,alpha,-beta},{-beta,0,alpha} };
	    //float testState[3] = {0.1,0.2,0.1};
	    matrix = (float**)malloc(N * sizeof(float*));
	    adjMatrix = (int**)malloc(N * sizeof(int*));
	    state = (float*)malloc(N * sizeof(float));
	    for (int i=0; i<N; i++) {
		matrix[i] = (float*)malloc(N * sizeof(float));
		adjMatrix[i] = (int*)malloc(N * sizeof(int));
		for (int j=0; j<N; j++) {
		    matrix[i][j] = i==j ? alpha : ((j-i+N)%N) == 1 ? -beta : 0;
		    adjMatrix[i][j] = ((j-i+N)%N) == 1;
		}
		//matrix[i][j] = testMatrix[i][j];
		//state[i] = testState[i];
		state[i] = 0.4 + 0.2*i;
	    }

	    if (graph)
		stochastic=true;
	    if (stochastic)
		stochastify();
	    if (graph)
		calcGraphMatrix();
	}
};

#endif /* INC_STATE_H */
